# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Carp/Assert.pm) perl(Const/Fast.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Data/Dumper.pm) perl(Database/ManagedHandle.pm) perl(Database/Temp.pm) perl(English.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(FindBin.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Log/Any.pm) perl(Log/Any/Adapter/Util.pm) perl(Module/Load.pm) perl(Moo.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(Test/Database/Temp.pm) perl(Test/More.pm) perl(Test2/V0.pm) perl(lib.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name TheSchwartz-JobScheduler
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: Lightweight TheSchwartz job dispatcher with maintained database connections
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/TheSchwartz-JobScheduler

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MI/MIKKOI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
TheSchwartz::JobScheduler is an interface to insert a new job into
TheSchwartz job queue (maintained by a database).

The rationale behind this module is using it in a long running web service,
for instance, in the Dancer2 manpage. Because the database connections cannot
be relied to stay open indefinitely, we get a new database handle
for each operation.

This module is solely created for the purpose of injecting a new job
from web servers without loading additional TheSchwartz and
Data::ObjectDriver modules onto your system. Your TheSchwartz job worker
processes will still need to be implemented using the full featured
the TheSchwartz::Worker manpage module.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/T*

%changelog
