# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(ExtUtils/MakeMaker.pm) perl(Thread/Queue/Duplex.pm) perl(Thread/Queue/Queueable.pm) perl(Time/HiRes.pm) perl(base.pm) perl(threads.pm) perl(threads/shared.pm)
# END SourceDeps(oneline)
%define module_version 2.01
%define module_name Thread-Resource-RWLock
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.01
Release: alt1
Summary: read/write lock base class for Perl ithreads
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DA/DARNOLD/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Thread::Resource::RWLock provides both an inheritable abstract class,
as well as a concrete object implementation, to regulate concurrent
access to resources.
Multiple concurrent reader threads may hold a Thread::Resource::RWLock
readlock at the same time, while a single writer thread holds the lock
exclusively.

New reader threads are blocked if any writer is currently waiting to
obtain the lock. The read lock is granted after all pending write lock
requests have been released.

Thread::Resource::RWLock accomodates a thread which already holds
a lock and then requests another lock on the resource, as follows:

=over 4

=item no lock held, requests readlock

Lock is granted when any pending writelock requests
are applied, and then released. Returned value is a unique
locktoken value.

=item no lock held, requests writelock

Lock is granted when any current readlocks
are released. If multiple writelock requests are pending,
the writelock will be granted in a random fashion.
Returned value is a unique locktoken value.

=item holds readlock, requests readlock

The lock level remains the same, but the returned value
is -1, indicating a lock was already held.

=item holds readlock, requests writelock

The lock level is upgraded to write when all other
readers have unlocked, and the returned value
is -1, indicating a lock was already held.

=item holds writelock, requests readlock

The lock level is downgraded to read, regardless
if any other writelock requests are pending.
The returned value is -1, indicating a lock was
already held.

=item holds writelock, requests writelock

The lock level remains the same, but the returned value
is -1, indicating a lock was already held.

=back

In addition, both nonblocking and timed interfaces are
provided to permit acquiring a lock only if the lock can be granted
immediately, or within a specified number of seconds. If the lock
is not granted, the returned value is `undef'.

This implementation provides 2 constructors:
the usual `new()' method which constructs a shared object instance,
suitable for use as a member of a shared object,
and an `adorn()' method for classes which subclass Thread::Resource::RWLock.

Finally, note that this implementation supports both array and hash
based objects. *Array-based subclasses should reserve the first 4 entries
in their array for the Thread::Resource::RWLock member variables.*


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/T*

%changelog
