# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(threads.pm)
# END SourceDeps(oneline)
%define module_name Thread-Use
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: use a module inside a thread only
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LN/LNATION/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
*** A note of CAUTION ***

 This module only functions on Perl versions 5.8.0 and later.
 And then only when threads are enabled with -Dusethreads.  It
 is of no use with any version of Perl before 5.8.0 or without
 threads enabled.

                  *************************

When you are programming threaded applications and are interested in saving
memory by selectively loading modules inside threads only, you will find that
even if you `use' a module inside a thread, it is in fact available to all
threads, including the main thread.

This is caused by the fact that `use' is executed at compile time.  At which
time Perl doesn't know anything about threads yet.

However, some modules, specifically the ones that are (partly) implemented
in XS, do not (yet) survive the cloning process that is involved with creating
threads.  So you can only use these modules inside threads only.  But if you
`use' a module, it will be read in at compile time.

Of course, a `use' is nothing more than a `require' followed by a call
to the "import" class routine (if available).  But that doesn't feel natural
to do.  So this module allows you to use the `useit' (for use in
threads command to indicate that a module should only be used inside
a thread.

For example: suppose you only need the `PerlIO::gzip' module inside a thread:

 use Thread::Use;  # can be anywhere in your program

 threads->new( \&zipfile,filename,contents ); # start the thread

 sub zipfile {
   useit PerlIO::gzip;  # only use inside this thread
   open( my $out,'>:gzip', $_[0] ) or die "$_[0]: $!";
   print $out $_[1];
   close( $out );
 }

For completeness, it is also possible to pass any parameters as you would
with the `use' command.  So:

 sub storable {
   useit Storable qw(freeze); # export "freeze" to namespace of thread
   my $frozen = freeze( \@_ );
 }

or to use the opposite `no' equivalent;

 sub warnings {
   useit warnings "all";
   # special code
   noit warnings "all";
 }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CHANGELOG TODO README
%perl_vendor_privlib/T*

%changelog
