%set_perl_req_method relaxed
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Sub/Import.pm) perl(Test/More.pm) perl(Throwable/Factory.pm) perl(Try/Tiny.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Throwable-Factory-Try
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: exception handling for Throwable::Factory
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LC/LCOFFE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module provides a try/catch/finally mechanism to be used with `Throwable::Factory', based off `Try::Tiny::ByClass' and `Dispatch::Class'.
The goal is to provide a simple but powerful exception framework.

    use Throwable::Factory
        FooBarException => ['-notimplemented'],
        FooException => ['-notimplemented'],
    ;
    use Throwable::Factory::Try;

    try {
        FooBarException->throw('it happened again')
    }
    catch [
        'LWP::UserAgent' => sub { print 'Why are you throwing that at me' },
        ['LWP::UserAgent', 'HTTP::Tiny'] => sub { print 'Why are you throwing those at me' },
        'FooBarException' => sub { print shift },
        qr/^Foo/ => sub { FooException->throw },
        ['FooBarException','FooException'] => sub { print "One of these two" },
        '-notimplemented' => sub { print 'One of these' },
        [':str', qr/^Foo/] => sub { print 'String starting with Foo: ' . shift },
        ':str' => sub { print 'Just a string: ' . shift },
        '*' => sub { print 'default case' },
    ],
    finally {
        do_it_anyway()
    };
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
