%define module_name Tickit-Widget-Term
# BEGIN SourceDeps(oneline):
BuildRequires: /dev/pts perl(Convert/Color/RGB8.pm) perl(Convert/Color/XTerm.pm) perl(IO/Pty.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Object/Pad.pm) perl(Syntax/Keyword/Match.pm) perl(Term/VTerm.pm) perl(Test/More.pm) perl(Tickit.pm) perl(Tickit/Widget.pm) perl(XS/Parse/Sublike.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.006
Release: alt1
Summary: terminal emulation for Tickit
Group: Development/Perl
License: perl
URL: http://search.cpan.org/dist/Tickit-Widget-Term/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PEVANS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
In principle, a terminal widget would provide an abstraction for running any terminal application under
the Tickit manpage. This would include full support for attributes, cursor movement, scrolling, mouse/keyboard input,
and if used as the root window should be indistinguishable from running the code directly from the parent
terminal itself.

What you get with this module is a minimum-viable implementation for running a tiny subset of the
basic shell commands. It's a hack using cargo-culted the IO::Pty manpage pieces, manual forking under the IO::Async manpage,
and a vague understanding of terminal control codes based on watching low-budget police shows. It redraws
everything at the slightest excuse. You'd have to run reset(1) before you can even get your own keyboard
input echoing back. The code spends most of its time logging the endless list of features that aren't supported.

Having said that, here are some things you can expect to work:

=over 4

=item * ls (partly)

=item * some of the letters

=item * maybe the enter key

=back

Unlikely scenarios:

=over 4

=item * anything which does more than move the cursor or select one of the 8 colours.

=back

At this point, it's customary to mention that the module and API are experimental and likely to change.
Careful readers will already have noticed that this is a placeholder module and "likely to change" is
somewhat understated.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE examples
%perl_vendor_privlib/T*

%changelog
