# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Log/ger.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Tie-Array-File-LazyRead
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Read a file record by record using tied array and for()
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Tie-Array-File-LazyRead

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
EXPERIMENTAL, PROOF-OF-CONCEPT.

When `for()' is given a tied array:

 for (@tied_array) {
     ...
 }

it will invoke `FETCHSIZE' on the tied array to find out the size, then
FETCH(0), *then FETCHSIZE() again, then FETCH(1), and so on.* In other
words, `FETCHSIZE' is called on each iteration. This makes it possible to only
fetch new data in `FETCHSIZE' instead of `FETCH'.

Without using `for()':

 tie my @ary, 'Tie::Array::File::LazyRead', 'FILENAME.txt';

 print $ary[0];

will not print anything, and the first line of the file is not fetched. To fetch
one more line, you need to do:

 my $size = @ary;
 # then
 print $ary[0];

and so on.

=for Pod::Coverage ^(.+)$

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/T*

%changelog
