# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(Tie/Hash.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.09
%define module_name Tie-Cacher
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: Cache a (sub)set of key/value pairs. Tie and OO interface.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/T/TH/THOSPEL/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module implements a least recently used (LRU) cache in memory through.a tie and a OO interface.  Any time a key/value pair is fetched or stored,
an entry time is associated with it, and as the cache fills up, those members
of the cache that are the oldest are removed to make room for new entries.

So, the cache only "remembers" the last written entries, up to the
size of the cache.  This can be especially useful if you access
great amounts of data, but only access a minority of the data a
majority of the time.

The implementation is a hash, for quick lookups, overlaying a doubly linked
list for quick insertion and deletion. Notice that the OO interface will
be faster than the tie interface.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/T*
%perl_vendor_privlib/auto/*
%changelog
