# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_version 1.10
%define module_name Tie-DirHandle
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.10
Release: alt1
Summary: definitions for tied directory handles
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PI/PINYAN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module provides filehandle-like read access to directory handles.  There
are not many available methods, because directory handles are read-only.  The
only methods are `TIEHANDLE', `READLINE', `DESTROY', and `rewind'.

To tie a filehandle to a directory handle, the syntax is as follows:
    tie *FILEHANDLE, "Tie::DirHandle", *DIRHANDLE, "/path/to/dir";

The module will open the directory (and croak with an error if not able to do
so).  When untying the filehandle, the directory is closed.

After a filehandle has been tied to a directory handle, you can read from the
directory using the <HANDLE> syntax.  This syntax calls `READLINE'.

To rewind the directory, there are two possible syntaxes: (tied *FH)->rewind;
or $ref->rewind;

The second works if you have stored the return value of the tie in a variable
$ref.  The value of `tied *FH' and $ref are the same.

The variable $ref (or `tied *FH') contains a hash reference, with three keys.
$ref->{HANDLE} returns the directory handle it references.  $ref->{PATH} and
$ref->{DIR} are synonymous, and return the path of the directory.

=over

=item TIEHANDLE classname, DIRHANDLE, DIR

This ties the specified directory handle to the filehandle given as the first
argument to tie().  DIR is the pathname of the directory.

=item READLINE this

This returns the next value (if called in a scalar context) or the next values
(if returned in a list context) of readdir().

=item DESTROY this

This closes the directory.

=back


%prep
%setup -n Tie
# depth is > 1 .. moving up
pushd "DirHandle"
  mv -f * ../
  mv -f .* ../ ||:
popd

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/T*

%changelog
