# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 1.11
%define module_name Tie-Discovery
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.11
Release: alt1
Summary: Lazily evaluated "discovery" hashes
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AU/AUDREYT/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
A *discovery* hash is a hash that's designed to help you solve the data
dependency problem. It's based on the principle of least work; some
times, you may spend a lot of time in your program finding out paths,
filenames, operating system specifics, network information and so on
that you may not end up using. Discovery hashes allow you to get the
data when you need it, and only when you need it.

To use a discovery hash, first tie a hash as shown above. You will want
to keep hold of the object returned by `tie'. You can then add things
to discover by calling the `register' method as shown above. The above
code `$obj->register("os", \&discover_os);' means that when (and
only when!) the value `$info{os}' is fetched, the sub `&discover_os'
will be called to find it. The return value of that sub will then be
cached to save a look-up next time.

The real power comes from the fact that you may refer to the tied hash
inside of the discovery subroutines. This allows for fast, neat and
flexible top-down programming, and helps you avoid hard-coding values. 
For instance, let us find the OS by calling the uname program:

    $obj->register( os => sub {
        # Here $self is the same as $obj above
        my $self = shift;
        my $uname = $self->FETCH('path_to_uname');
        return `$uname`;
    } );

Alternatively, if the tied `%%info' is still in scope, this will also do:

    $obj->register( os => sub {
        my $uname = $info{path_to_uname};
        return `$uname`;
    } );

Now we need code to find the program itself:

    use Config;
    use File::Spec::Functions;
    $obj->register( path_to_uname => sub {
        my $self = shift;
        foreach (split($Config{path_sep}, $ENV{PATH})) {
            return catfile($_, 'uname') if -x catfile($_, 'uname');
        }
        die "Couldn't even find uname";
    };

Fetching `$info{os}' may now need a further call to fetch
`$info{path_to_uname}' unless the path is already cached. And, of
course, we needn't stop at two levels.

Note that, since version 1.10, as long as the discovery function
returns a code reference, it will be invoked repeatedly, until a
final value is produced.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/T*

%changelog
