%define module_name Tie-TZ
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Date/Calc.pm) perl(DateTime.pm) perl(DateTime/TimeZone.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(FindBin.pm) perl(HTML/Entities.pm) perl(Pod/Simple/HTML.pm) perl(Test/More.pm) perl(constant.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 11
Release: alt1
Summary: Tied TZ env var calling tzset() when changed.
Group: Development/Perl
License: gpl
URL: http://user42.tuxfamily.org/tie-tz/index.html

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KR/KRYDE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Tie::TZ' provides a tied `$TZ' variable which gets and sets the TZ
environment variable `$ENV{'TZ'}'.  When it changes `%%ENV' it calls
`tzset()' (see the POSIX manpage) if available, ensuring the C library notices the
change for subsequent `localtime' etc.

    $TZ = 'GMT';
    # does  $ENV{'TZ'}='GMT'; POSIX::tzset();

For a plain set you can just as easily store and `tzset' yourself (or have
a function do the combo).  The power of a tied variable comes when using
`local' to have a different timezone temporarily.  Any `goto', `return',
`die', etc, exiting the block will restore the old setting, including a
`tzset' for it.

    { local $TZ = 'GMT';
      print ctime();
      # TZ restored at block exit
    }

    { local $TZ = 'GMT';
      die 'Something';
      # TZ restored when the die unwinds
    }

Storing `undef' to `$TZ' deletes `$ENV{'TZ'}' and unsets the environment
variable.  This generally means the timezone goes back to the system default
(/etc/timezone or wherever).

As an optimization, if a store to `$TZ' is already what `$ENV{'TZ'}'
contains then `POSIX::tzset()' is not called.  This is helpful if some of
the settings you're using might be the same -- just store to `$TZ' and it
notices when there's no change.  If you never store anything different from
the startup value then the `POSIX' module is not even loaded.

If `tzset' is not implemented on your system then `Tie::TZ' just sets the
environment variable.  This is only likely on a very old or very limited C
library.  Of course setting the environment variable might or might not
affect the timezone in force (see the Time and Date entry in the perlport manpage).


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYING Changes examples
%perl_vendor_privlib/T*

%changelog
