%define module_version 0.003
%define module_name Time-Limit
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: kill your broken Perl script
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Time-Limit

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
It is oh so very easy to accidentally write a Perl script that dives
straight into an infinite loop, or stumbles into a runaway recursion.
In most cases, you can hit `Ctrl + C' and get on with the job of
figuring out what went wrong. However, if you're not running the
process in a local terminal (e.g. you're running it over a slow SSH
connection, or not in a terminal at all), these processes might be
tricky to kill.

The Time::Limit module starts a monitor process that shadows your
script's execution, and kills it off if your script has overrun its
allotted time limit. Because Time::Limit is global in effect its use
in modules is discouraged. Instead, use it only in your main script,
or pass it as a parameter to Perl on the command line:

   perl -MTime::Limit myscript.pl

The syntax for using Time::Limit is:

   use Time::Limit @flags, $limit;

Flags are strings prefixed with a hyphen. The following flags are
supported:

=over

=item `-group'

Send the signal to your script's process group instead of its
individual process number. That is, your script and any child
processes started with `fork' will be killed.

=item `-quiet'

Kill the script quietly.

=item `-verbose'

Output extra debugging information.

=back

The `$limit' is a number indicating the time in seconds
before your script gets killed. It does not have to be an integer.
It defaults to a very generous 10.

Be careful to avoid triggering Perl's `use MODULE VERSION'
syntax.

   use Time::Limit -verbose, 4.0;  # yep, kill after 4 seconds
   use Time::Limit '4.0';          # yep, kill after 4 seconds
   use Time::Limit 4.0;            # nah, want $VERSION==4.0

After `$limit' is reached, Time::Limit will try signalling your
script to terminate cleanly (SIGTERM) a few times; if that fails,
it will become more aggressive and send SIGKILL signals until it
receives word of your script's timely death.

Some random examples using Time::Limit from the command-line:

   perl -MTime::Limit=-quiet,4 myscript.pl
   perl -MTime::Limit=-group,-verbose,4.1 myscript.pl
   perl -MTime::Limit=3 myscript.pl


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYRIGHT LICENSE Changes README examples
%perl_vendor_privlib/T*

%changelog
