# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(I18N/Langinfo.pm) perl(Module/Build.pm) perl(Module/Signature.pm) perl(Socket.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.09
%define module_name Time-Normalize
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: Convert time and date values into standardized components.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RO/ROODE/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Splitting a date into its component pieces is just the beginning.

Human date conventions are quirky (and I'm not just talking about the
dates *I've* had!)  Despite the Y2K near-disaster, some people
continue to use two-digit year numbers.  Months are sometimes
specified as a number from 1-12, sometimes as a spelled-out name,
sometimes as a abbreviation.  Some months have more days than others.
Humans sometimes use a 12-hour clock, and sometimes a 24-hour clock.

This module performs simple but tedious (and error-prone) checks on
its inputs, and returns the time and/or date components in a
sanitized, standardized manner, suitable for use in the remainder of
your program.

Even when you get your values from a time-tested library function,
such as `localtime' or `gmtime', you need to do routine
transformations on the returned values.  The year returned is off by
1900 (for historical reasons); the month is in the range 0-11; you may
want the month name or day of week name instead of numbers.  The
the normalize_time entry elsewhere in this document function decodes `localtime''s values into
commonly-needed formats.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/T*

%changelog
