%define module_name Time-Piece-Guess
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(Time/Piece.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.1
Release: alt1
Summary: Compares the passed string against common patterns and returns a format to use with Time::Piece or ...
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VV/VVELOX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Time::Piece::Guess;
    use Time::Piece;

    my $string='2023-02-27T11:00:18.33';
    my ($format, $ms_clean_regex) = Time::Piece::Guess->guess('2023-02-27T11:00:18');
    # apply the regex if needed
    if (defined( $ms_clean_regex )){
        $string=~s/$ms_clean_regex//;
    }
    my $tp_object;
    if (!defined( $format )){
        print "No matching format found\n";
    }else{
        $tp_object = Time::Piece->strptime( '2023-02-27T11:00:18' , $format );
    }

    $tp_object = Time::Piece::Guess->guess_to_object('2023-02-27T11:00:18');
    if (!defined( $tp_object )){
        print "No matching format found\n";
    }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes
%perl_vendor_privlib/T*

%changelog
