# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(JSON/Tiny.pm) perl(List/AllUtils.pm) perl(Moo.pm) perl(Test/Deep.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Time/Progress.pm) perl(Types/Standard.pm) perl(autobox/Core.pm) perl(true.pm)
# END SourceDeps(oneline)
%define module_version 1.002
%define module_name Time-Progress-Stored
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.002
Release: alt1
Summary: Report progress + store and retrieve the current status
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JO/JOHANL/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module helps if you have a long running process which reports
progress, but you need to actually display the progress to the user in
a different process.

Typically this is a long running web request in the web server or in a
job queue worker, while the web browser periodically sends Ajax
requests to get updated on the current progress status to show using a
progress bar.

Time::Progress::Stored stores the progress report as the worker
performs its job, and retrieves it from elsewhere where the report is
needed.

The report is a hashref with the following details:

    | id                | "progress-1454518121172"   |
    | max               | 262                        |
    | current           | 2                          |
    | activity          | "Importing Users"          |
    | elapsed_seconds   | "1"                        |
    | elapsed_time      | " 0:01"                    |
    | finish_time       | "Wed Feb 3 16:50:54 2016"  |
    | percent           | 0.8                        |
    | percent_string    | " 0.8%%"                    |
    | remaining_seconds | "130"                      |
    | remaining_time    | " 2:10"                    |
    | is_done           | 0                          |
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/T*

%changelog
