%define module_name Time-TAI-Simple
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTTP/Tiny.pm) perl(POSIX/RT/Clock.pm) perl(Test/Differences.pm) perl(Test/Most.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.16
Release: alt1
Summary: Easily obtain current TAI time, using UNIX epoch.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TT/TTKCIAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The `Time::TAI::Simple' module provides a very simple way to obtain the
number of seconds elapsed since the beginning of the UNIX epoch (January
1st, 1970).

It differs from `Time::HiRes' in that it returns the actual number of
elapsed seconds, unmodified by the leap seconds introduced by the IETF
to make UTC time.  These leap seconds can be problematic for automation
software, as they effectively make the system clock stand still for one
second every few years.

D. J. Bernstein describes other problems with leapseconds-adjusted time
in this short and sweet article: http://cr.yp.to/proto/utctai.html

`Time::TAI::Simple' provides a monotonically increasing count of seconds,
which means it will never stand still or leap forward or backward due to
system clock adjustments (such as from NTP), and avoids leapseconds-related
problems in general.

This module differs from Time::TAI
and Time::TAI::Now in a few
ways:

=over 4

* it is much simpler to use,

* it uses the same epoch as perl's `time' builtin and `Time::HiRes', not the IETF's 1900-based epoch,

* it is a "best effort" implementation, accurate to a few microseconds,

* it depends on the local POSIX monotonic clock, not an external atomic clock.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc TODO LICENSE Changes README touch-before-release.txt README.md
%perl_vendor_privlib/T*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
