Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(WidgetDemo.pm) perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Tk-CursorControl
Version:        0.4
Release:        alt2_36
Summary:        Manipulate the mouse cursor programmatically
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Tk-CursorControl
Source0:        https://cpan.metacpan.org/authors/id/D/DU/DUNNIGANJ/Tk-CursorControl-%{version}.tar.gz
# don't install cursor.pl demo - add to docs instead
Patch0:         perl-Tk-CursorControl-no-demos.patch
# disable interactive tests (reenable --with interactive-tests)
Patch1:         perl-Tk-CursorControl-no-interactive-test.patch
%bcond_with     interactive_tests
BuildArch:      noarch
# Build
BuildRequires:  findutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  sed
# Runtime
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Tk.pm)


Source44: import.info

%description
This module offers a Tk programmer the functionality of warping, moving,
confining or hiding a mouse cursor.

%prep
%setup -q -n Tk-CursorControl-%{version}
%patch0 -p1
%if %{without interactive_tests}
%patch1 -p1
%endif

# strip CRLF
find -type f -print0 | xargs -0 sed -i 's/\r$//'

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes README demos/cursor.pl
%{perl_vendor_privlib}/*

%changelog
