# BEGIN SourceDeps(oneline):
BuildRequires: perl(Tk.pm) xvfb-run
# END SourceDeps(oneline)
%ifndef _build_display
%def_without test
%endif
%define module_version 0.23
%define module_name Tk-DynaTabFrame
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.23
Release: alt1
Summary: A NoteBook widget with orientable, dynamically stacking tabs
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DA/DARNOLD/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
[ NOTE: This module was based on Tk::TabFrame...
but you probably can't tell it anymore ]

A notebook widget with orientable, dynamically rearranging tabs. 
When the containing window is resized, the tabs will either stack or 
unstack as needed to fit the enclosing widget's width(height). 
Likewise, when tabs are added or removed, the tabs will stack/unstack 
as needed.

Tabs may be placed either on the top (default), bottom, left, or right
side of the widget, and may be aligned to either the 
left (default) or right edge for top or bottom tabs, or to the
top or bottom edges for left or right tabs.

Tabs are added at the innermost row adjacent to the tabbed frame
at the alignment edge, and automatically become the "raised" tab 
when added.

Separate -tabcolor and -raisecolor options may be specified
for each tab. -tabcolor is used for the tab if it is not the
raised tab, or if no -raisecolor is specified. -raisecolor
is used when the tab is raised.

A tab can be raised by either clicking on the tab; by 
using left and right keyboard arrows to traverse the tabbing order;
or programmatically via the raise() method.

If -tabrotate is enabled, when a tab in a row other than the 
innermost frame-adjacent row is raised, all rows are rotated inward, 
with the current frame-adjacent rows wrapping to the outside, until 
the raised row becomes the innermost frame adjacent row. Disabling
-tabrotate will leave the raised tab in its current location (assuming
the containing window has not been resized; see the -tablock
option to lock down the tabs on resize events).

A small "close" button can be applied to the tabs via the -tabclose
option. By default, clicking the close button will delete the 
tab and associated frame from the DynaTabFrame. If a coderef
is supplied as the -tabclose value, then the coderef will be invoked 
instead.

Either text or images can be displayed in the tab, using either
the -image or -label page options. A future release will permit both
in a single tab. If neither is specified, then the page name 
value will be used.

A "flash" effect may be applied to a tab (i.e., switching between the
defined background color and a flash color at a specified interval) using 
the flash() method. Flashing continues until either the 
deflash() method is called, the tab is raised manually or 
programmatically, or the specified flash duration expires.

A "tabtip" *(aka balloon or tooltip)* may be attached to each tab 
that is displayed when the mouse hovers over the tab. The number of millseconds
between the mouse entering a tab, and the display of the tabtip is determined
by the -tiptime option (default 450). The background color
of the tabtips can be set by the -tipcolor option (default
white). The text of each tabtip can be set, updated, or removed, either in 
the add() method, or via pageconfigure(),
using the -tabtip option. Note that a the Tk::Balloon manpage widget
is not created for the DynaTabFrame widget until a -tiptime,
-tipcolor, or -tabtip is configured.

The widget takes all the options that a Frame does. In addition,
it supports the following options:

=over 4

=item -font

Font for tab text.

=item -raisecmd

Code ref invoked on a raise event; passed
the caption of the raised page. NOTE:This behavior
is different than Tk::Notebook, which passes
the widget to the callback.

=item -raisecolor

Sets the default raisecolor; overridden by add(-raisecolor)
option. Default is current widget background color.

=item -tabclose

Add small close button to each tab; if set to a coderef,
the coderef is invoked when the close button is pressed, 
and is passed both the Tk::DynaTabFrame object, and the 
caption of the associated tab. If set to a 'true' scalar 
value, invokes the delete method on the associated tab.
Default is no close button. When enabled with -tablock 
enabled, -tablock is silently ignored. 

=item -tabcolor, -backpagecolor

Sets the default tabcolor; overridden by the
add(-tabcolor) option. Default is current widget background 
color.

=item -tabcurve

Curve to use for top corners of tabs; set to the number of pixels
of spacing between adjoining tab borders. Default 2; *rarely needs
adjustement*.

=item -tablock

Locks the resize of the tabs; when set to a true
value, the tabs will not be rearranged when the enclosing 
window is resized; default off (ie, tabs are rearranged
on resize). Silently ignored when -tabclose is enabled.
Note that this options does not effect the tab raise event
behavior (tab rows rotate inward). See the -tabrotate
option to disable that behavior.

=item -tabpadx

Padding on left and right of the tab contents

=item -tabpady

Padding on top and bottom of the tab contents

=item -tabrotate

When enabled (the default), when a tab is raised in a row other 
than the innermost, frame-adjacent row, tab rows are rotated inward
until the raised tab is frame adjacent. Disabling this option will
leave the raised tab's row at its current location until a resize event
occurs. (See -tablock to lock down tab locations
on resize events).

=item -tabside

Side of notebook to align tabs; acceptable values:

_'nw' (default) - tabs on top, aligned to the left edge
_'ne' - tabs on top, aligned to the right edge
_'sw' - tabs on bottom, aligned to the left edge
_'se' - tabs on bottom, aligned to the right edge
_'en' - tabs on right, aligned to the top edge
_'es' - tabs on right, aligned to the bottom edge
_'wn' - tabs on left, aligned to the top edge
_'ws' - tabs on left, aligned to the bottom edge
_'n'  - same as 'nw'
_'s'  - same as 'sw'
_'e'  - same as 'en'
_'w'  - same as 'wn'

Note: can only be set or changed prior to adding any
pages; attempts to change the -tabside after pages
have been added will be silently ignored.

=item -tabscroll *(not yet implemented)*

When set to a true value, causes tabs to be restricted to
a single row, with small arrow buttons placed at either end
of the row to permit scrolling the tabs into/out of the
window. When a tab is programmatically raised, the tabs will
be scrolled until the raised tab is visible.

=item -textalign

Aligns text to the tab orientation. When enabled (i.e., set to
a 'true' scalar, the default), text in tabs is aligned to the 
tab orientation (i.e., top and bottom tabs have horizontal text, 
side tabs have vertical text). When disabled (i.e., set to undef or 0),
text will be vertical for top and bottom tabs, and horizontal for
side tabs.

=item -tipcolor

Sets the background color of any tabtips (default white). 
Causes creation of a the Tk::Balloon manpage widget if none yet exists.

=item -tiptime

Sets the integer number of milliseconds to delay between the time 
the mouse enters a tab and the display of any defined tabtip. Default 450.
Causes creation of a the Tk::Balloon manpage widget if none yet exists.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build
xvfb-run -a make test

%install
%perl_vendor_install

%files
%doc Changes.txt
%perl_vendor_privlib/T*

%changelog
