# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test.pm) perl(Tk.pm) perl(Tk/Button.pm) perl(Tk/Entry.pm) perl(Tk/Label.pm) perl(Tk/Toplevel.pm) perl(Tk/widgets.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.10
%define module_name Tk-EntryDialog
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: Dialog widget with text entry.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RK/RKIES/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
The -font option defaults to *-helvetica-medium-r-*-*-12-*.
  The -defaultentry option supplies the default text in the Entry
  widget.

  The -textlabel option prints the text of its argument in label above
  the text entry box.

  After WaitForEntry is called, clicking on the 'Accept' button or
  pressing Enter in the text entry widget, closes the dialog and returns
  the text in the entry box.

  The WaitForEntry method does not destroy the dialog window.  Instead 
  WaitForEntry unmaps the dialog box from the display.  To de-allocate 
  the widget, you must explicitly call $w -> destroy or $w -> DESTROY.

  Refer to the Tk::options man page for a description of options 
  common to all Perl/Tk widgets.

  Example:

    use Tk;
    use Tk::EntryDialog;

    my $w = new MainWindow;

    my $b = $w -> Button (-text => 'Dialog',
                          -command => sub{&show_dialog($w)}) -> pack;

    sub show_dialog {
        my ($w) = @_;
        my $e;
        if (not defined $e) {
_    $e = $w -> EntryDialog (-title => 'Enter Text');
            $e -> configure (-defaultentry => 'Default text');
_    $e -> configure (-textlabel => 'Please enter your text:');
        }
        my $resp = $e -> WaitForInput;
_print "$resp\n";
_$e -> configure (-textlabel => '');
_$e -> configure (-defaultentry => 'New entry without label.');
        my $resp = $e -> WaitForInput;
_print "$resp\n";
        return $resp;
    }

    MainLoop;


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/T*

%changelog
