# BEGIN SourceDeps(oneline):
BuildRequires: perl(Tk.pm) perl(Tk/Derived.pm) perl(Tk/Entry.pm) perl(Tk/MMutil.pm) perl(Tk/widgets.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_name Tk-FmtEntry
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1
Release: alt4
Summary: Formatted Entry widget
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RO/ROSCIO/%{module_name}-%{version}.tar.gz

%description
A normal Entry widget, but it may enforce some format upon the entered value.  
For example, telephone number, credit-card, or currency (money) formats.  
The programmer must supply the formatting function.
See below for examples.

Otherwise, this acts a like a normal Entry widget, except for some restrictions
on the use of -validate.

The following additional options/value pairs are supported:

=over 4

=item -delay

Normally, the formatting function is called as soon as possible after any edit
to the contents of the FmtEntry field.  However, you may want to delay the
formatting a bit, so multiple edits to the field can be "batched" and handled
at once.  This may also be useful when swipe-card reads are to be extracted
from a field that's also a user-entry (type-in) field.

Use the -delay option to specify the number of milliseconds to wait
before the formatting fuction is invoked.   Edits to the field must be idle
for this amount of time before the format function is called: if you set an 
80ms delay, for example, and the edits come in with 65ms, 79ms, 55ms, then 81ms
pauses, the call will occur after the last pause (not after each).

Note that users typically percieve delays of more than 80ms.

=item -formatcommand

Alias: -fcmd

The formatting function.  This function is called to cleanup,
correct, and/or [re]format the value contained in the entry.
It is called with three arguments: the (possibly) unformatted string
in the entry field, and the current insertion cursor index, and a reference
to the FmtEntry widget.

The function should return two values: the cleaned-up string,
and the revised insertion cursor point.  If the revised insertion point is
not returned (undef), then a simplistic correlation algorithm will
be used to guess the new insertion cursor point.  It's not a very
good guess, so the cursor may not be where you expect it.  Thus, your
formatting function should calculate and return the revised position.

An example may help.  Suppose we want to enforce all entries to be
lowercase.  In t...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%perl_vendor_archlib/T*
%changelog
