Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Tk/Dial.pm) perl(Tk/DirSelect.pm) perl(Tk/FileDialog.pm) perl(Tk/NumEntry.pm) perl(Tk/PathEntry.pm) perl(WidgetDemo.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Tk-Getopt
Version:        0.51
Release:        alt2_22
Summary:        User configuration window for Tk with interface to Getopt::Long
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Tk-Getopt
Source0:        https://cpan.metacpan.org/authors/id/S/SR/SREZIC/Tk-Getopt-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(Getopt/Long.pm)
BuildRequires:  perl(Safe.pm)
BuildRequires:  perl(Tk.pm)
# Optional      perl(Tk::Balloon)
BuildRequires:  perl(Tk/BrowseEntry.pm)
BuildRequires:  perl(Tk/CmdLine.pm)
# Optional fall back  perl(Tk::DirSelect)
BuildRequires:  perl(Tk/DirTree.pm)
# Optional  perl(Tk::FileDialog) is old and buggy. Tk::FileSelect is fall-back
BuildRequires:  perl(Tk/FileSelect.pm)
BuildRequires:  perl(Tk/Font.pm)
# Optional not yet packaged  perl(Tk::FontDialog)
# Optional      perl(Tk::NoteBook)
BuildRequires:  perl(Tk/Optionmenu.pm)
# Optional not yet packaged  perl(Tk::PathEntry)
BuildRequires:  perl(Tk/Photo.pm)
BuildRequires:  perl(Tk/Pixmap.pm)
BuildRequires:  perl(Tk/Tiler.pm)
# Tests
BuildRequires:  perl(Test/More.pm)
# Optional tests
BuildRequires:  perl(File/Temp.pm)
# Optional not yet packaged  perl(Tk::Dial)
Requires:       perl(Cwd.pm)
Requires:       perl(Data/Dumper.pm)
Requires:       perl(File/Basename.pm)
Requires:       perl(File/Spec.pm)
Requires:       perl(Getopt/Long.pm)
Requires:       perl(Safe.pm)
Requires:       perl(Tk.pm) >= 804
# Optional      perl(Tk::Balloon)
Requires:       perl(Tk/BrowseEntry.pm)
Requires:       perl(Tk/CmdLine.pm)
# Optional fall back  perl(Tk::DirSelect)
Requires:       perl(Tk/DirTree.pm)
# Optional  perl(Tk::FileDialog) is old and buggy. Tk::FileSelect is fall-back
Requires:       perl(Tk/FileSelect.pm)
Requires:       perl(Tk/Font.pm)
# Optional not yet packaged  perl(Tk::FontDialog)
# Optional      perl(Tk::NoteBook)
Requires:       perl(Tk/Optionmenu.pm)
# Optional not yet packaged  perl(Tk::PathEntry)
Requires:       perl(Tk/Photo.pm)
Requires:       perl(Tk/Pixmap.pm)
Requires:       perl(Tk/Tiler.pm)

# Filter optional not yet packaged  perl(Tk::PathEntry)

Source44: import.info
%filter_from_requires /^perl(Tk.PathEntry.pm)/d

%description
Tk::Getopt provides an interface to access command line options via
Getopt::Long and editing with a graphical user interface via a Tk window.

%prep
%setup -q -n Tk-Getopt-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc Changes demos README
%{perl_vendor_privlib}/*

%changelog
