%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBI.pm) perl(ExtUtils/MakeMaker.pm) perl(Tk.pm) perl(Tk/Frame.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 1.0
%define module_name Tk-GridEntry
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0
Release: alt1
Summary: Composite widget for a set of widgets in a grid form
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RA/RAMAN/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
=over 4
Tk::GridEntry defines a set of widgets associated with an hash of arrays.

Creation of GridEntry is a three step process.

Step 1:
First define the set of widget in hash-of-hash. The hash-of-hash 
should have element with key "columns", which refers to an array 
which holds the widget names, in the order of creation. Each entry 
in this array becomes a column in the grid.

'columns'=>["col1","col2"]

Next attributes of individual columns should be specified as 
hash. e.g

'col1'=>{'widgettype'=>'Entry',       #widget
         'label'     =>'Col1',        #Column Title
         'bindings'  =>"FocusOut subname",#Event
         -width=>10,
         -foreground=>'Red'

_}

The hash in fact contains two sets of data. The elements like 
'widgettype', 'label', 'bindings' are attributes of 
the whole column. 

The elements with '-' at the beginning like '-width' '-font' 
are passed to the individual widget. Thus in the above example 
you get column with title 'Col1', full of Entry widgets, with 
FocusOut bind to focusoutsub subroutine. The width of widget 
will be 10.

Step 2
Once the structure is defined, the GridEntry widget can be created. 

$ge=$top->GridEntry(
       -structure=>$whash    #The widget structure 
                              as in step1
       -datahash=>$datahash  #Reference to hash of arrays 
                              tobe displayed
       -rows=>'10'           #No.of rows in the grid
       -scroll=>'1'          #Scroll buttons yes/no
       )->pack();

Step 3

The data should be populated. The data is arranged as hash of array.
Each hash keys are column names, and element of hash-of array are the
data.

Two situtations are possible 
1. You want to display existing data and allow editing.
   The data must be arranged in a hash of arrays e.g

for (my $i=0;$i<10;$i++){
      $datahash->{'col1'}[$i]=$i;
      $datahash->{'col2'}[$i]=sprintf "col2.%%d",$i;
      }
        
After populating datahash with whatever data required, call

_$ge->moverectoscreen();

_$ge->update();

This will set textvariable in each widget to corresponding array
element in data.  Any editing on the gridentry will be done on 
data hash also as textvariable is set.

By default rows are equal to the no.of elements in array. If you need 
additonal blank rows, use extend property. specifying '-extend=>10' 
will allow ten elements to be added to arrays in datahash.

2.Want to display blank grid.

First set '-extend' to whatever number of rows you want.
Like '-extend=>100'.  
Just set datahash={} (prior to widget definition) and 
moverecscreen. 

The hash-of-array grows as data is keyed in.

Navigation:

The user may browse with the Page up/down keys. 
Arrow keys can be used move between currently display rows.
If scroll option is set, scroll buttons can be used to scroll 
page up/down.
If browsecmd is set, whenever, pages are scrolled the callback 
is executed.



%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/T*

%changelog
