# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Tk-Role-HasWidgets
%define upstream_version 1.112380

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_10

Summary:    Keep track of your tk widgets
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Tk/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(File/Find.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Moose/Role.pm)
BuildRequires: perl(MooseX/Has/Sugar.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Module/Build.pm)
BuildArch: noarch
Source44: import.info

%description
When programming the Tk manpage, it's almost always a good idea to keep a
reference to the widgets that you created in the interface. Most of the
time, a simple hash is enough; but it is usually wrapped up in methods to
make the hash private to the window object. And of course, those methods
are duplicated in all modules, under a form or another.

Since duplication is bad, this module implements a the Moose manpage role
implementing those methods once and forever. This implies that your class
is using the Moose manpage in order to consume the role.

About the method names
    The methods featured in this role begin with '_', that is, they are
    following Perl convention of private methods. This is on purpose:
    remember that this method is a role, consumed by your class. And you
    don't want those methods to be available outside of the window class,
    do you?

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Build.PL installdirs=vendor
./Build

%check
./Build test

%install
./Build install destdir=%{buildroot}

%files
%doc README Changes LICENSE META.yml META.json
%perl_vendor_privlib/*


%changelog
