%define module_name Tk-SimpleFileSelect
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Tk.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.29
Release: alt1
Summary: Simple file selection dialog.
Group: Development/Perl
License: Artistic
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AS/ASB/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Tk::SimpleFileSelect is an easy to use file selection widget based on
the Tk::FileSelect manpage.  Unlike a the Tk::FileSelect manpage widget, Tk::SimpleFileSelect
does not attempt to verify that a file exists.  A Tk::SimpleFileSelect
dialog returns the complete pathname of the selected file.  The
calling program is responsible for file validation and operations.

Clicking on an item in the List box selects the item and displays the
text in the Entry box.  Double clicking on a directory or entering its
name in the Entry box changes to that directory.

Pressing Escape, `Alt-C', or clicking the Cancel button closes the 
dialog and returns an empty string.

The `Show()' method causes the Tk::SimpleFileSelect to wait until a
file is selected in the List box, a file name is entered
in the text entry widget, or the, "Cancel," button is clicked.

Closing the dialog withdraws its window from the display.  The widget
must be deleted explicitly.  The `Show()' method can open a
Tk::SimpleFileSelect object that has already been created.

The return value of `Show()' is the pathname of a file selected in the
List box, or the path of the filename in the text entry, or an empty
string.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CHANGES.txt Artistic README
%perl_vendor_privlib/T*

%changelog
