%define module_name Tree-Cladogram
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Slurper.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(Getopt/Long.pm) perl(Image/Magick.pm) perl(Imager.pm) perl(Imager/Fill.pm) perl(Moo.pm) perl(Pod/Usage.pm) perl(Test/Pod.pm) perl(Test/Simple.pm) perl(Tree/DAG_Node.pm) perl(Types/Standard.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.04
Release: alt1
Summary: Render a cladogram using Imager or Image::Magick
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RS/RSAVAGE/%{module_name}-%{version}.tgz
BuildArch: noarch

%description
`Tree::Cladogram' provides a mechanism to turn a tree into a cladogram image.
The image is generated using the Imager manpage or the Image::Magic manpage.

The image type created is determined by the suffix of the output file. See
the What image formats are supported? entry elsewhere in this document for details.

The details of the cladogram are read from a text file. See the the FAQ entry elsewhere in this document for details.

For information about cladograms, see https://en.wikipedia.org/wiki/Cladogram.

For another sample of a cladogram, see
http://phenomena.nationalgeographic.com/2015/12/11/paleo-profile-the-smoke-hill-bird/.

Sample input is shipped as data/*.clad.
The corresponding output is shipped as data/*.png, and is on-line:

wikipedia.01.clad output by Imager

wikipedia.01.clad output by Image::Magick

nationalgeographic.01.clad output by Imager

nationalgeographic.01.clad output by Image::Magick

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README Changelog.ini
%perl_vendor_privlib/T*

%changelog
