# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Tree/Dump.pm) perl(Tree/Object/Hash.pm) perl(strict.pm) perl(warnings.pm) perl(Role/TinyCommons/Tree/NodeMethods.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Tree-Create-Callback
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Create tree object by using a callback
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Tree-Create-Callback

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Building a tree manually can be tedious: you have to connect the parent and
the children nodes together:

 my $root = My::TreeNode->new(...);
 my $child1 = My::TreeNode->new(...);
 my $child2 = My::TreeNode->new(...);

 $root->children([$child1, $child2]);
 $child1->parent($root);
 $child2->parent($root);

 my $grandchild1 = My::Class->new(...);
 ...

This module provides a convenience function to build a tree of objects in a
single command. You supply a callback to create node and the function will
connect the parent and children nodes for you.

The callback is called with these arguments:

 ($parent, $level, $seniority)

where `$parent' is the parent node object (or undef if creating the root node,
which is the first time the callback is called), `$level' indicates the current
depth of the tree (starting from 0 for the root node, then 1 for the root's
children, then 2 for their children, and so on). You can use this argument to
know where to stop creating nodes. `$seniority' indicates the position of the
node against its sibling (0 means the node is the first child of its parent, 1
means the second, and so on). You can use this argument to perhaps customize the
node according to its sibling order.

The callback should return a list:

 ($node, $num_children)

where `$node' is the created node object (the object can be of any class but it
must respond to `parent' and `children', see the Role::TinyCommons::Tree::Node manpage
for more details on the requirement), `$num_children' is an integer that
specifies the number of children that this node should have (0 means this node
is to be a leaf node). The children will be created when the function calls the
callback again later for each child node.
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/T*

%changelog
