# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(IO/File.pm) perl(base.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name		Tree-Interval
%define upstream_version 0.3

	
Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_11

Summary:    Perl implementation of an interval tree
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Log/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Error.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Test/Unit.pm)
BuildArch:  noarch
Source44: import.info

%description
This is a perl implementation of an interval tree for non-overlapping intervals, based on Tree::RedBlack by Benjamin Holzman <bholzman@earthlink.net>. An interval tree is a binary tree which remains "balanced" i.e. the longest length from root to a node is at most one more than the shortest such length. It is fairly efficient; no operation takes more than O(log(N)) time.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc META.yml 
%perl_vendor_privlib/* 


%changelog
