# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Tree-Nary
%define upstream_version 1.3

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_10

Summary:	Tree::Nary - Perl implementation of N-ary search trees
License:	GPL+ or Artistic
Group:		Development/Perl
Url:		https://metacpan.org/release/%{upstream_name}
Source0:	https://cpan.metacpan.org/authors/id/F/FS/FSORIANO/%{upstream_name}-%{upstream_version}.tar.bz2

BuildArch:	noarch
Source44: import.info


%description
The Tree::Nary class implements N-ary trees (trees of data with any 
number of branches), providing the organizational structure for a tree
(collection) of any number of nodes, but knowing nothing about the specific
type of node used.  It can be used to display hierarchical database entries in
an internal application (the NIS netgroup file is an example of such a
database). It offers the capability to select nodes on the tree, and attachment
points for nodes on the tree. Each attachment point can support multiple child
nodes.

The data field contains the actual data of the node. The next and previous
fields point to the node's siblings (a sibling is another node with the same
parent). The parent field points to the parent of the node, or is undef if the
node is the root of the tree. The children field points to the first child of
the node. The other children are accessed by using the next pointer of each
child.  This module is a translation (albeit not a direct one) from the C
implementation of N-ary trees, available in the GLIB distribution (see SEE
ALSO).

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc CHANGES README
%{perl_vendor_privlib}/Tree/*.pm

%changelog
