# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(Module/Build.pm) perl(Storable.pm) perl(Test/More.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Tree-Predicate
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: a balanced, splittable tree for SQL predicates
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MA/MARSHALL/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Tree::Predicate allows the composition of a tree of SQL predicates that
can then be "split" into UNION-able predicats that do not contain an OR.

    use Tree::Predicate qw(:logical);
    
    my $left_branch = OR('a', 'b');
    my $right_branch = OR('c', 'd');
    my $tree = AND($left_branch, $right_branch);
    
    print $tree->as_string; # ((a OR b) AND (c OR d))
    
    my @trees = $tree->split;
    # four trees
    # (a AND c)
    # (a AND d)
    # (b AND c)
    # (b AND d)
    
    $tree->negate;
    print $tree->as_string; # ((NOT(a) AND NOT(b)) OR (NOT(c) AND NOT(d)))


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
