%define module_name Tree-RB-XS
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(Carp.pm) perl(Data/Printer.pm) perl(Exporter.pm) perl(ExtUtils/Depends.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test2/Suite.pm) perl(Test2/Tools/Subtest.pm) perl(Test2/V0.pm) perl(Time/HiRes.pm) perl(XSLoader.pm) perl(lib.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.18
Release: alt1
Summary: Red/Black Tree container with similar API to Tree::RB
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NERDVANA/%{module_name}-%{version}.tar.gz

%description
This module is a wrapper for a Red/Black Tree implemented in C.  It's primary features over
other search trees on CPAN are optimized comparisons of keys (speed), `O(log N)'
node-by-index lookup (which allows the tree to act as an array), and the option to
allow duplicate keys while preserving insertion order.

The API is almost a complete superset of the Tree::RB manpage with a few differences:

=over

=item *

The `get' method in this module is not affected by array context, unless you
request the compat_list_get entry elsewhere in this document.

=item *

`resort' is not implemented (would be lots of effort, and unlikely to be needed)

=item *

Tree structure is not mutable via the attributes of Node, nor can nodes be created
independent from a tree.

=item *

Many functions have official names changed, but aliases are provided for compatibility.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md example
%perl_vendor_archlib/T*
%perl_vendor_autolib/*

%changelog
