# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(List/Util.pm) perl(Test/Simple.pm) perl(Tree/DAG_Node.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Tree-Serial
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2
Release: alt1
Summary: Perl module for deserializing lists of strings into tree-like structures
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SL/SLITTL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The purpose of the module is to turn lists of strings (typically passed on the command line) into tree-like structures: hashes and lists of lists (of lists, etc.; i.e. nested). 

The idea is that you would instantiate the deserializer class that this package provides, passing it a number of parameters:

=over

=item *

the `separator' meaning the dummy piece of string that indicates an empty node;

=item * 

the `degree', meaning the maximal degree the deserializer assumes all tree nodes have. Whatever missing nodes there are, you will then have to indicate by instances of the above-mentioned `separator';

=item * 

the `traversal': a non-negative integer between 0 and `degree' that tells the deserializer where to place the root when producing a list of lists.

=back

You always specify the tree nodes in pre-order traversal; the `traversal' attribute specifies what sort of *output* to produce. An example: assuming the `separator' is `'.'' and the `degree' is 2 (the default), the list 

    1 2 4 . 7 . . . 3 5 . . 6 . . 

would represent the binary tree

               `
        1
       / \
      2   3
     /   / \
    4   5   6
     \
      7

The initial inspiration was provided by this discussion, which applies to binary trees only. The present module handles `k'-ary trees for arbitrary `k E<ge> 2'.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.pod
%perl_vendor_privlib/T*

%changelog
