%define module_name Treex-PML
%filter_from_requires /^perl.arybase.pm./d
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(File/ShareDir.pm) perl(File/Which.pm) perl(IO/Zlib.pm) perl(LWP/UserAgent.pm) perl(Test/More.pm) perl(UNIVERSAL/DOES.pm) perl(URI.pm) perl(XML/CompactTree.pm) perl(XML/CompactTree/XS.pm) perl(XML/LibXML.pm) perl(XML/LibXSLT.pm) perl(XML/SAX.pm) perl(XML/Writer.pm) perl(XML/XPath.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.28
Release: alt1
Summary: Perl implementation of the Prague Markup Language (PML) and related data models.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CH/CHOROBA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Treex::PML provides among other the following classes:

=over 4

=item the Treex::PML::Factory manpage

a factory class which delegates object creation to a default factory
class, which can be specified by the user (defaults to
the Treex::PML::StandardFactory manpage).  It is important that both user and
library code uses the create methods from the Treex::PML::Factory manpage to
create new objects rather than calling constructors from an explicit
object class.

This classical Factory Pattern allows the user to replace the standard
family of `Treex::PML' classes with customized versions by setting up
a customized factory as default. Then, all objects created by the
Treex::PML library and applications will be from the customized
family.

=item the Treex::PML::StandardFactory manpage

the standard factory class.

=item the Treex::PML::Document manpage

representing a PML document consisting of a set of trees.

=item the Treex::PML::Node manpage

representing a node of a tree (including the root node, which also
represents the whole tree), see
the section on "Representation of trees" in the Treex::PML::Node manpage for details.

=item the Treex::PML::Schema manpage

representing a PML schema.

=item the Treex::PML::Instance manpage

implementing a PML instance.

=item the Treex::PML::List manpage

implementing a PML list.

=item the Treex::PML::Alt manpage

implementing a PML alternative.

=item the Treex::PML::Seq manpage

implementing a PML sequence.

=item the Treex::PML::Container manpage

implementing a PML container.

=item the Treex::PML::Struct manpage

implementing a PML attribute-value structure.

=item the Treex::PML::FSFormat manpage

representing an old-style document format for documents in the FS
format.

=back
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes ignore.txt README
%perl_vendor_privlib/T*

%changelog
