%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(MooseX/FollowPBP.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name TryCatch-Error
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: A simple error base class.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PF/PFIG/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module provides a building block to writing your own error objects, to use with TryCatch (or some similar module).

It enables you to write things like this, straight away:

    use TryCatch::Error;
    use TryCatch;

    try {
        # ...
        # something that can go horribly wrong
        if ( $error_condition ) {
            die TryCatch::Error->new( value => $foo, message => $bar );
        }
    }
    catch ( TryCatch::Error $e ) {
        print STDERR 'Ooops: ', $e->get_message, ' with ', $e->get_value;
    }

TryCatch::Error can be sub-classed to create your own errors (possibly containing more detail, see t/03-subclassing.t for an example).


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
