%define module_name Types-Self
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter/Tiny.pm) perl(ExtUtils/MakeMaker.pm) perl(Role/Hooks.pm) perl(Role/Tiny.pm) perl(Test/More.pm) perl(Types/Standard.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: provides a "Self" type constraint, referring to the caller class or role
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Types-Self

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module exports a `Self' type constraint which consrtains values to be
blessed objects in the same class as the package it was imported into, or
blessed objects which consume the role it was imported into. It should do
the right thing with inheritance.

This module also exports `is_Self', which returns a boolean.

  package Marriage;
  use Moo::Role;
  use Types::Self qw( is_Self );
  
  has spouse => ( is => 'rwp', init_arg => undef );
  
  sub marry {
    my ( $me, $maybe_spouse ) = @_;
    if ( is_Self( $maybe_spouse ) ) {
      $me->_set_spouse( $maybe_spouse );
      $maybe_spouse->_set_spouse( $me );
    }
    else {
      warn "Cannot marry this!";
    }
    return $me;
  }

The module also exports `assert_Self' which acts like `is_Self' but instead
of returning a boolean, either lives or dies. This can be useful is you need
to check that the first argument to a function is a blessed object.

  sub connect {
    my ( $self ) = ( shift );
    assert_Self $self;  # dies if called as a class method
    $self->{connected} = 1;
    return $self;
  }

The module also exports `to_Self' which will attempt to coerce other types
to the Self type.

Only `Self' is exported by default.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README CREDITS LICENSE Changes COPYRIGHT
%perl_vendor_privlib/T*

%changelog
