# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Method/Lexical.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Object/AUTHORITY.pm) perl(Parse/CPAN/Meta.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(base.pm) perl(inc/Module/Package.pm) perl(overload.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_version 0.003
%define module_name UNIVERSAL-AUTHORITY-Lexical
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: an AUTHORITY method for every class, within a lexical scope
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/UNIVERSAL-AUTHORITY-Lexical

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module adds an `AUTHORITY' method to the `UNIVERSAL' package, which
works along the same lines as the `VERSION' function. Because it is defined
in `UNIVERSAL', it becomes instantly available as a method for any blessed
objects, and as a class method for any package.

The method is defined only for the lexical scope you import this package
into. For example:

  {
    use UNIVERSAL::AUTHORITY::Lexical;
    say Moose->AUTHORITY;
  }
  say Moose->AUTHORITY;  # no such method, dies.

The authority of a package can be defined like this:

 package MyApp;
 BEGIN { $MyApp::AUTHORITY = 'cpan:JOEBLOGGS'; }

The authority should be a URI identifying the person, team, organisation
or trained chimp responsible for the release of the package. The
pseudo-URI scheme `cpan:' is the most commonly used identifier.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README COPYRIGHT Changes
%perl_vendor_privlib/U*

%changelog
