Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Pod/Coverage/TrustPod.pm) perl(Test/CPAN/Meta.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-URI-Title
Version:        1.904
Release:        alt1_4
Summary:        Get the titles of things on the web in a sensible way
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/URI-Title
Source0:        https://cpan.metacpan.org/authors/id/B/BO/BOOK/URI-Title-%{version}.tar.gz
BuildArch:      noarch
# Build
BuildRequires:  coreutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Runtime
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Encode.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(File/Type.pm)
BuildRequires:  perl(HTML/Entities.pm)
BuildRequires:  perl(HTTP/Request.pm)
BuildRequires:  perl(HTTP/Response.pm)
BuildRequires:  perl(Image/Size.pm)
BuildRequires:  perl(LWP/UserAgent.pm)
BuildRequires:  perl(Module/Pluggable.pm)
BuildRequires:  perl(MP3/Info.pm)
BuildRequires:  perl(utf8.pm)
# Tests only
BuildRequires:  perl(blib.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(IO/Handle.pm)
BuildRequires:  perl(IO/Socket.pm)
BuildRequires:  perl(IO/Socket/INET.pm)
BuildRequires:  perl(IPC/Open3.pm)
BuildRequires:  perl(lib.pm)
# Needed for Twitter in live tests
BuildRequires:  perl(LWP/Protocol/https.pm)
BuildRequires:  perl(Test/More.pm)
# Optional tests needs net connections
#BuildRequires:  perl(Image::ExifTool)
Requires:       perl(Encode.pm)
Requires:       perl(File/Type.pm) >= 0.220
Requires:       perl(LWP/Protocol/https.pm)
Requires:       perl(Module/Pluggable.pm) >= 1.200
Requires:     perl(Image/ExifTool.pm)



Source44: import.info
%filter_from_requires /^perl(File.Type.pm)/d
%filter_from_requires /^perl(Module.Pluggable.pm)/d

%description
I keep having to find the title of things on the web.  This seems like a really
simple request, just get() the object, parse for a title tag, you're done.
Ha, I wish.  There are several problems with this approach:

What if the resource is on a very slow server?  Do we wait forever or what?
What if the resource is a 900 gig file?  You don't want to download that.
What if the page title isn't in a title tag, but is buried in the HTML
somewhere?
What if the resource is an MP3 file, or a word document or something?
...

So, let's solve these issues once.

%package tests
Group: Development/Other
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       perl(Image/ExifTool.pm)

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n URI-Title-%{version}
# Help generators to recognize Perl scripts
for F in t/*.t; do
    perl -i -MConfig -ple 'print $Config{startperl} if $. == 1 && !s{\A#!.*perl\b}{$Config{startperl}}' "$F"
    chmod +x "$F"
done

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*

# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t %{buildroot}%{_libexecdir}/%{name}
rm -rf %{buildroot}%{_libexecdir}/%{name}/t/author-*
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%files
%doc --no-dereference LICENSE
%doc Changes README eg/title.pl
%{perl_vendor_privlib}/*

%files tests
%{_libexecdir}/%{name}

%changelog
