# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose/Util/TypeConstraints.pm) perl(MooseX/InsideOut.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Sub/Exporter.pm) perl(Test/More.pm) perl(YAML.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm) perl(mro.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name URI-http-Dump
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: A module to assist in the reverse engineering of URL parameters.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/E/EC/ECARROLL/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The simplicity of Unix is in the way it treats (most) everything like a file, and this is just a simplicity mechanism so you can treat URIs as a file too via YAML markup, ie, easily manipulate them with a text editor.

Say you're trying to reverse engineer a website for the purpose of automation and the URL that is causing annoyance has a shit ton of parameters with numerous different quirks: ie, base64 encoding, custom encoding, hexecoding nonsense, or maybe they just spelt everything in pig latin. Now, for reasons known to the reader, you need to make sense of this: this module will help you.

This module really has a small scope, and the route of action it takes depends entirely on the existance of the URI's file-store. On the first invocation, before the file-store exists, URI::http::Dump will decompile the URL provided to new() to its basic URI components and store it to a file.

On the second invocation, URI::http::Dump will compile the URI from the components in the file-store and output the URI to stdout. It will continue on this route for each subsequent invocation until the file-store is deleted. Then it will re-render the file from the arguments to constructor so you can begin the process again.

Because of the internal function of the URI module query segments encoded and unencoded in the respective steps, ie., the file will probably look more ledgable than the URI by default.

If you have deep voodoo you need to do to the URI in an automated fashion you can utilize a Moose *around* method modifier on the `->load' or `->dump' functions.

 All URIs must start with http:// 

 The CANONICAL_SRC element in the dump *NEVER* changes. It is there for reference only 


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/U*

%changelog
