# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/pod2pdf.pm) perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/Most.pm) perl(URI.pm) perl(YAML/Tiny.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name URI-redis
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: URI for Redis connection info
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/ME/MENDEL/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
The `URI::redis' class supports `URI' objects belonging to the *redis* and
*redis+unix* URI scheme.

Such URLs are used to encode connection info (`redis': host, port, password,
database, `redis+unix': socket path, password, database) to Redis servers.


Supported URLs are in any of these formats:

=over

=item `redis://HOST[:PORT][?db=DATABASE[&password=PASSWORD]]'

=item `redis://HOST[:PORT][?password=PASSWORD[&db=DATABASE]]'

=item `redis://[:PASSWORD@]HOST[:PORT][/DATABASE]'

=item `redis://[:PASSWORD@]HOST[:PORT][?db=DATABASE]'

=item `redis://HOST[:PORT]/DATABASE[?password=PASSWORD]'

A TCP connection, see
http://www.iana.org/assignments/uri-schemes/prov/redis.

The port defaults to 6379 and the host defaults to "localhost".

=item `redis+unix://[:PASSWORD@]SOCKET_PATH[?db=DATABASE]'

=item `redis+unix://SOCKET_PATH[?db=DATABASE[&password=PASSWORD]]'

=item `redis+unix://SOCKET_PATH[?password=PASSWORD[&db=DATABASE]]'

A Unix domain socket connection.

=back


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/U*

%changelog
