# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Pod/Coverage/TrustPod.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl-podlators
# END SourceDeps(oneline)
BuildRequires: /proc
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Ubic
%define upstream_version 1.60

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_5

Summary:    Dummy credentials module
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module//%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Class/Accessor/Fast.pm)
BuildRequires: perl(Config/Tiny.pm)
BuildRequires: perl(Cwd.pm)
BuildRequires: perl(Data/Dumper.pm)
BuildRequires: perl(Exporter.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Fcntl.pm)
BuildRequires: perl(File/Basename.pm)
BuildRequires: perl(File/Copy.pm)
BuildRequires: perl(File/Find.pm)
BuildRequires: perl(File/Path.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(File/Which.pm)
BuildRequires: perl(Getopt/Long.pm)
BuildRequires: perl(HTTP/Server/Simple/CGI.pm)
BuildRequires: perl(IO/Handle.pm)
BuildRequires: perl(IO/Select.pm)
BuildRequires: perl(IO/Socket.pm)
BuildRequires: perl(IPC/Open3.pm)
BuildRequires: perl(JSON.pm)
BuildRequires: perl(List/MoreUtils.pm)
BuildRequires: perl(List/Util.pm)
BuildRequires: perl(POSIX.pm)
BuildRequires: perl(Params/Validate.pm)
BuildRequires: perl(Pod/Usage.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Storable.pm)
BuildRequires: perl(Term/ANSIColor.pm)
BuildRequires: perl(Test/Class.pm)
BuildRequires: perl(Test/Fatal.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Time/HiRes.pm)
BuildRequires: perl(Try/Tiny.pm)
BuildRequires: perl(lib.pm)
BuildRequires: perl(overload.pm)
BuildRequires: perl(parent.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
This module is a perl frontend to ubic services.

It is a singleton OOP class. All of its methods should be invoked as class
methods:

    Ubic->start('foo');
    Ubic->stop('foo');
    my $status = Ubic->status('foo');

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make

%check
rm -f t/watchdog.t
%make test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.yml  README
%{perl_vendor_privlib}/*
%{_bindir}/ubic
%{_bindir}/ubic-admin
%{_bindir}/ubic-daemon
%{_bindir}/ubic-periodic
%{_bindir}/ubic-update
%{_bindir}/ubic-watchdog
%{_mandir}/man1/ubic-admin.1*
%{_mandir}/man1/ubic-daemon.1*
%{_mandir}/man1/ubic-periodic.1*
%{_mandir}/man1/ubic-update.1*
%{_mandir}/man1/ubic-watchdog.1*
%{_mandir}/man1/ubic.1*

%changelog
