# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(DateTime.pm) perl(DateTime/Duration.pm) perl(DateTime/Span.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/Exception.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Ucam-Term
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 3.00
Release: alt1
Summary: return information about the start and end dates of terms (and a few related events) at the Univers...
Group: Development/Perl
License: Perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JW/JWAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The academic year at the University of Cambridge, UK, is divided into
three *Terms* - *Michaelmas* (autumn), *Lent* (spring) and
*Easter* (summer). The half-way point of each term is called the
*Division of Term*. Three quarters of each Term is designated *Full
Term*, during which lectures are given and when undergraduate students
are normally required to be in residence. Near the end of the Easter
Term there are three or four days of *General Admission*, during which
degrees are conferred on those who have just successfully completed
courses, followed by the *Long Vacation period of residence* during
which some additional courses of instruction are given.

The dates of some of these events and periods are fixed, but others
depend on dates that appear in the University's published 'Ordnances'
(see the SEE ALSO entry elsewhere in this document below for references) which are updated from time to
time. This version of the module contains data covering the period
from the Michaelmas Term 2007 to the Easter Term 2030.

This module returns the DateTime manpage or the DateTime::Span manpage objects
corresponding to these events and periods. Note that the
DateTime::Span objects run from 00:00 (inclusive) on the day the
period starts to 00:00 (exclusive) on the day after the period ends
(see DateTime::Span->end_is_open). This means that
union/intersection/complement/intersects/contains operations will all
work correctly, but that it is normally necessary to subtract one day
from the end date of the span in order to find the date of the last
day of the period.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE README.pod Changes
%perl_vendor_privlib/U*

%changelog
