# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(charnames.pm)
# END SourceDeps(oneline)
%define module_name Unicode-Char
%define _without_test 1
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: OO interface to charnames and others
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DA/DANKOGAI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides OO interface to Unicode characters.

=over 2

=item `$u->u()'

Returns a character whose Unicode Number is the argument.

  $u->u('5c0f'); # "small" in Kanji

But the following is handier.

  $u->u5c0f;    # same thing but as a method

These methods are generatated on demand.

=item `$u->n()'

Returns a character whose Unicode Canonical Name is the argument.

  $u->n('white smiling face'); 

But as  `$u->u()', you may prefer the handier version:

  $u->white_smiling_face;

As you many have noticed, these names do not have to be all in caps.
Just replace spaces with underscore.

=item `$u->name()'

Returns the Unicode Canonical Name of the character.;

  my $name    = $u->name(chr(0x263A)); # WHITE SMILING FACE



=item `$u->names()'

Same as above but in list context.

  my (@names) = $u->name("perl"); # ('LATIN SMALL LETTER P',
                                  #  'LATIN SMALL LETTER E',
                                  #  'LATIN SMALL LETTER R',
                                  #  'LATIN SMALL LETTER L')

=back


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/U*

%changelog
