%define module_name Unicode-Truncate
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Encode.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(XSLoader.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.303
Release: alt6
Summary: Unicode-aware efficient string truncation
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FR/FRACTAL/%{module_name}-%{version}.tar.gz

%description
This module is for truncating UTF-8 encoded Unicode text to particular byte lengths while inflicting the least amount of data corruption possible. The resulting truncated string will be no longer than your specified number of bytes (after UTF-8 encoding).

All truncated strings will continue to be valid UTF-8: it won't cut in the middle of a UTF-8 encoded code-point. Furthermore, if your text contains combining diacritical marks, this module will not cut in between a diacritical mark and the base character. It will in general try to preserve what users perceive as whole characters, with as little as possible mutilation at the truncation site.

The `truncate_egc' function truncates only between extended grapheme clusters (as defined by Unicode TR29 version 7.0.0).

The `truncate_egc_inplace' function is identical to `truncate_egc' except that the input string will be modified so that no copying occurs. If you pass in a read-only value it will throw an exception.

Eventually I'd like to support other boundaries such as words and sentences. Those functions will be named `truncate_word' and so on.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/U*
%perl_vendor_autolib/*

%changelog
