%define module_name Unit-Duration
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/EOL.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Portability/Files.pm) perl(Test/Synopsis.pm) perl(Test2/V0.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.04
Release: alt1
Summary: Work-time unit duration conversion and canonicalization
Group: Development/Perl
License: artistic_2
URL: https://github.com/gryphonshafer/Unit-Duration

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GR/GRYPHON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This class provides the ability to "canonicalize" time durations based on custom
time units and their relationships to each other.

As an illustrative example, let's say you're a project manager dealing with
work-time duration estimates for a set of tasks. These might be weeks, days,
hours, or some combination of these units and/or other units. In the context of
work-time duration, 1 day does not equal 24 hours. The standard convention is  1
day equals 8 hours and 1 week equals 5 days. However, this is not universal. In
France, for example, the work week is typically 35 hours, not 40.

Assuming the default/typical case, though, let's say you have a task that's
estimated to take 12 hours. You can represent that duration as "12 hours" or
"12 hrs" or "1 day, 4 hours" or "1.5 days" or "1d 4h" or any number of other
ways.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/U*

%changelog
