Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(DBD/mysql.pm) perl(DBI.pm) perl(HTTP/Daemon/SSL.pm) perl(HTTP/Response.pm) perl(HTTP/Status.pm) perl(IO/Socket/SSL.pm) perl(Pod/Simple/Text.pm) perl(Term/ReadKey.pm) perl(XML/Parser.pm) perl-podlators
# END SourceDeps(oneline)
%filter_from_requires /^perl.VOMS.Lite.Attribs.SHIBHelper.pm./d
%add_findreq_skiplist %perl_vendor_privlib/VOMS/*.pl
%add_findreq_skiplist /usr/sbin/voms-*.pl 
%add_findreq_skiplist %_bindir/voms-*.pl 
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}

Name:           perl-VOMS-Lite
Version:        0.20
Release:        alt2_25
Summary:        Perl extension for VOMS Attribute certificate creation
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/VOMS-Lite
Source0:        ftp://ftp.funet.fi/pub/CPAN/authors/id/M/MI/MIKEJ/VOMS-Lite-%{version}.tar.gz
Source1:        voms.config
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
%if 0%{?el4}%{?el5}
BuildRequires:  sed
%endif
BuildRequires:  perl(Crypt/CBC.pm)
BuildRequires:  perl(Crypt/DES_EDE3.pm)
# Data::Dumper not used at tests
# DBI not used at tests
BuildRequires:  perl(Digest/MD5.pm)
BuildRequires:  perl(Digest/SHA1.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(File/Copy.pm)
# HTTP::Daemon::SSL not used at tests
# HTTP::Response not used at tests
# HTTP::Status not used at tests
# IO::Socket not used at tests
# IO::Socket::SSL not used at tests
BuildRequires:  perl(Math/BigInt.pm)
BuildRequires:  perl(MIME/Base64.pm)
# Pod::Simple::Text not used at tests
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(Sys/Hostname.pm)
# Term::ReadKey not used at tests
BuildRequires:  perl(Time/Local.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(warnings.pm)
# XML::Parser not used at tests
# Optional run-time:
# Digest::MD2 not used at tests
BuildRequires:  perl(Math/BigInt/GMP.pm)
# Tests:
%{?!tests_req:%global tests_req BuildRequires: }
BuildRequires:      perl(Cwd.pm)
BuildRequires:      perl(Sys/Hostname.pm)
BuildRequires:      perl(Test.pm)
Requires:       perl(Crypt/DES_EDE3.pm)
Requires:       perl(Pod/Simple/Text.pm)
# Optional run-time:
Requires:       perl(Digest/MD2.pm)
Requires:       perl(Math/BigInt/GMP.pm)

# RPM 4.8 style
# Remove WIN32::API from the requires. It is only ever loaded 
# on that platform.
%{echo 
%filter_from_requires /^perl.WIN32.API.pm./d

}
#Add a test sub package.
%{?perl_default_subpackage_tests}
# RPM 4.9 style

Source44: import.info

%description
VOMS (virtual organization membership service) is a system for 
managing grid level authorization data within 
multi-institutional collaborations via membership and roles
within that membership.

VOMS::Lite provides a perl library and client tools 
for interacting with an existing voms service including the 
well known C implementation of voms.

A number of commands are included for generating and processing 
proxies including  voms-proxy-init.pl, voms-ac-issue.pl, ...

Configuration of client tools can be supplied via 
$ENV{'VOMS_CONFIG_FILE'} or else ~/.grid-security/voms.conf. 
The root user only uses /etc/grid-security/voms.config.

%package -n perl-voms-server
Group: Development/Other
Summary:    Perl extension for VOMS Attribute certificate creation
Requires:   perl-VOMS-Lite = %{version}-%{release} 

%description -n perl-voms-server
VOMS (virtual organization membership service) is a system for 
managing grid level authorization data within 
multi-institutional collaborations via membership and roles
within that membership.

A server voms-server.pl providing a perl implementation
of a VOMS server.

%prep
%setup -q -n VOMS-Lite-%{version}
cp -p %{SOURCE1} .

#On .el4 and .el5 we filter requires the old fashined
#way still.  The magic stuff about won't work.
%if 0%{?el4}%{?el5}
cat << \EOF > %{name}-req
#!/bin/sh
%{__perl_requires} $* |\
sed -e '/perl(WIN32::API)/d'
EOF

%global __perl_requires %{_builddir}/VOMS-Lite-%{version}/%{name}-req
chmod +x %{__perl_requires}
%endif # end of if el4,5.

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install

make pure_install DESTDIR=%{buildroot}
# I believe the voms-server.pl was meant to be installed in 
# sbin.
mkdir %{buildroot}%{_sbindir}
mv %{buildroot}%{_bindir}/voms-server.pl %{buildroot}%{_sbindir}/voms-server.pl
mv %{buildroot}%{_bindir}/vomsserver.pl %{buildroot}%{_sbindir}/vomsserver.pl
find %{buildroot} -type f -name .packlist -exec rm -f {} \;
find %{buildroot} -depth -type d -exec rmdir {} 2>/dev/null \;

# %{_fixperms} %{buildroot}/*

# Install a default configuration file and directory for VO grid-mapfiles.
mkdir -p %{buildroot}%{_sysconfdir}/grid-security/grid-mapfile.d
install -p -m 644 voms.config %{buildroot}%{_sysconfdir}/grid-security/voms.config

%check
make test

%files
%doc Changes README TODO 
%{perl_vendor_privlib}/*
%{_bindir}/cert-init.pl
%{_bindir}/cert-req.pl
%{_bindir}/examineAC.pl
%{_bindir}/extractVOMS.pl
%{_bindir}/myproxy-get.pl
%{_bindir}/myproxy-init.pl
%{_bindir}/proxy-init.pl
%{_bindir}/verifycert.pl
%{_bindir}/voms-ac-issue.pl
%{_bindir}/voms-proxy-init.pl
%{_bindir}/voms-proxy-list.pl
%{_mandir}/man1/cert-init.pl.1*
%{_mandir}/man1/cert-req.pl.1*
%{_mandir}/man1/examineAC.pl.1*
%{_mandir}/man1/extractVOMS.pl*
%{_mandir}/man1/myproxy-get.pl*
%{_mandir}/man1/myproxy-init.pl*
%{_mandir}/man1/proxy-init.pl*
%{_mandir}/man1/verifycert.pl*
%{_mandir}/man1/voms-ac-issue.pl.1*
%{_mandir}/man1/voms-proxy-init.pl.1*
%{_mandir}/man1/voms-proxy-list.pl.1*

%dir %{_sysconfdir}/grid-security
%dir %{_sysconfdir}/grid-security/grid-mapfile.d
%config(noreplace) %{_sysconfdir}/grid-security/voms.config

%files -n perl-voms-server
%{_sbindir}/voms-server.pl
%{_sbindir}/vomsserver.pl
%{_mandir}/man1/voms-server.pl.1*
%{_mandir}/man1/vomsserver.pl.1*


%changelog
