%define module_name Valiant
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Attribute/Handlers.pm) perl(Carp.pm) perl(Catalyst/Component/InstancePerContext.pm) perl(Catalyst/ControllerPerContext.pm) perl(Catalyst/Model/DBIC/Schema.pm) perl(Catalyst/Runtime.pm) perl(Catalyst/View/BasePerRequest.pm) perl(Catalyst/View/Errors/HTML.pm) perl(Catalyst/View/MojoTemplate/PerContext.pm) perl(CatalystX/QueryModel.pm) perl(CatalystX/RequestModel.pm) perl(Class/Method/Modifiers.pm) perl(DBD/SQLite.pm) perl(DBIx/Class.pm) perl(DBIx/Class/Candy.pm) perl(DBIx/Class/Storage/Debug/PrettyPrint.pm) perl(Data/Dumper.pm) perl(Data/Localize.pm) perl(Data/Perl/Collection/Array.pm) perl(DateTime.pm) perl(DateTime/Format/SQLite.pm) perl(DateTime/Format/Strptime.pm) perl(Devel/StackTrace.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(FreezeThaw.pm) perl(HTML/Escape.pm) perl(Import/Into.pm)
BuildRequires: perl(JSON/MaybeXS.pm) perl(Lingua/EN/Inflexion.pm) perl(Module/Pluggable/Object.pm) perl(Module/Runtime.pm) perl(Moo.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(MooseX/MarkAsMethods.pm) perl(MooseX/MethodAttributes.pm) perl(MooseX/NonMoose.pm) perl(Object/Pad.pm) perl(Plack/Runner.pm) perl(Role/Tiny/With.pm) perl(Scalar/Util.pm) perl(String/CamelCase.pm) perl(Sub/Util.pm) perl(Test/DBIx/Class.pm) perl(Test/Lib.pm) perl(Test/Most.pm) perl(Test/Needs.pm) perl(Text/Autoformat.pm) perl(Type/Tiny.pm) perl(URI.pm) perl(namespace/autoclean.pm) perl(namespace/clean.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002003
Release: alt1
Summary: Validation Library
Group: Development/Perl
License: perl
URL: https://github.com/jjn1056/Valiant

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JJ/JJNAPIORK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
WARNING: This is early release code.  I've been using it for a while on personal projects
and have a lot of test cases but there's probably corners I've not hit yet.   All documented
features should work as described.  I will only change API and functionality in a breaking
manner if its the only way to fix problems (caveat that I am reserving the right to change
the way errors are listed and structured for nested validations, for now, as well as the
way we resolve files for internationalization, whose current code may not be as performant
as needed; additionally the the Valiant::DBIx::Class manpage packages are all currently subject to
breaking changes as needed).

Domain level validations for the Moo manpage classes and related capabilities such as attribute
filtering and internationalization.  Provides a domain specific language
which allows you to defined for a given class what a valid state for an instance of that
class would be and to gather reportable error messages.  Used to defined constraints
related to business logic or for validating user input (for example via CGI forms).

When we say domain level or business logic validation, what we mean is that
invalid data is a possible and expected state that needs to be evaluated and reported to
the end user for correction.  For example when writing a web application you might have
a form that requests user profile information (such as name, DOB, address, etc).  Its an
expected condition that the user might submit form data that invalid in some way (such
as a DOB that is in the future) but is still 'well formed' and is able to be processed.
In these cases your business logic would be to inform the user of the incorrect data and
request fixes (rather than simply throw a 500 server error and giving up).  

This differs from type constraints (such as the Type::Tiny manpage) that you might put on your
the Moo manpage attributes which are used to express when attributes have values that are
so unacceptable that no further work can be done and an exception mus...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE README.mkdn Changes example
%perl_vendor_privlib/V*
%perl_vendor_privlib/D*
%perl_vendor_privlib/C*

%changelog
