Group: Engineering
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:          perl-Verilog-Perl
Version:       3.478
Release:       alt2_2
Summary:       Verilog parsing routines
License:       LGPLv3 or Artistic 2.0
URL:           http://www.veripool.org/wiki/verilog-perl
Source0:       https://cpan.metacpan.org/authors/id/W/WS/WSNYDER/Verilog-Perl-%{version}.tar.gz

BuildRequires: bison
BuildRequires: coreutils
BuildRequires: gcc-c++
BuildRequires: libgdbm-devel
BuildRequires: findutils
BuildRequires: flex
BuildRequires: perl-devel
BuildRequires: rpm-build-perl
BuildRequires: perl-devel
BuildRequires: perl(Carp.pm)
BuildRequires: perl(Config.pm)
BuildRequires: perl(Digest/SHA.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Copy.pm)
BuildRequires: perl(Getopt/Long.pm)
BuildRequires: perl(IO/File.pm)
BuildRequires: perl(Pod/Usage.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(vars.pm)
# Run-time
BuildRequires: perl(base.pm)
BuildRequires: perl(Cwd.pm)
BuildRequires: perl(DynaLoader.pm)
BuildRequires: perl(Exporter.pm)
BuildRequires: perl(File/Basename.pm)
BuildRequires: perl(File/Path.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(FindBin.pm)
BuildRequires: perl(lib.pm)
BuildRequires: perl(Scalar/Util.pm)
# Tests
BuildRequires: perl(Data/Dumper.pm)
BuildRequires: perl(POSIX.pm)
BuildRequires: perl(Test.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Time/HiRes.pm)
BuildRequires: perl(warnings.pm)
# Optional tests
BuildRequires: perl(Devel/Leak.pm)
BuildRequires: perl(Storable.pm)
BuildRequires: perl(Test/Pod.pm)


Provides:      perl-Verilog     = %{version}-%{release}
Obsoletes:     perl-Verilog     < 3.213-2

# Filtering Requires: and Provides



Source44: import.info
%filter_from_provides /^perl(\(imp_test_pkg\|mypackage\).pm)/d
%filter_from_requires /^perl(\(imp_test_pkg\|mypackage\).pm)/d

%description
This package provides functions to support writing utilities
that use the Verilog language.

%package tests
Group: Engineering
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       perl(Devel/Leak.pm)
Requires:       perl(Storable.pm)

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n Verilog-Perl-%{version}

# Help file to recognise the Perl scripts
for F in t/*.t t/*.pl; do
    perl -i -MConfig -ple 'print $Config{startperl} if $. == 1 && !s{\A#!.*perl\b}{$Config{startperl}}' "$F"
    chmod +x "$F"
done

%build
CFLAGS="%{optflags}" perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
find %{buildroot} -type f -name '*.bs' -size 0 -delete
# %{_fixperms} %{buildroot}

%if 0
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t verilog %{buildroot}%{_libexecdir}/%{name}
rm -f %{buildroot}%{_libexecdir}/%{name}/t/00_pod.t
rm -f %{buildroot}%{_libexecdir}/%{name}/t/01_manifest.t
rm -f %{buildroot}%{_libexecdir}/%{name}/t/02_help.t
rm -f %{buildroot}%{_libexecdir}/%{name}/t/03_spaces.t
for i in vhier vpassert vppreproc vrename vsplitmodule; do
    ln -s %{_bindir}/$i %{buildroot}%{_libexecdir}/%{name}/
done
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
set -e
# Some tests write into temporary files/directories. The easiest solution
# is to copy the tests into a writable directory and execute them from there.
DIR=$(mktemp -d)
pushd "$DIR"
cp -a %{_libexecdir}/%{name}/* ./
prove -I .
popd
rm -rf "$DIR"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test
%endif

%check
# Free Electronic Lab : Package Self Test
make test

%files
%doc --no-dereference COPYING
%doc Changes README verilog/
%dir %{perl_vendor_archlib}/Verilog/
%dir %{perl_vendor_archlib}/auto/Verilog/
%{_bindir}/*
%{perl_vendor_archlib}/Verilog/*
%{perl_vendor_archlib}/auto/Verilog/*
%{_mandir}/man?/*

%if 0
%files tests
%{_libexecdir}/%{name}
%endif

%changelog
