%define module_name Vroom
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(File/HomeDir.pm) perl(IO/All.pm) perl(Template/Toolkit/Simple.pm) perl(Term/Size.pm) perl(Test/Pod.pm) perl(Text/Balanced.pm) perl(YAML/PP.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.42
Release: alt1
Summary: Slide Shows in Vim
Group: Development/Perl
License: perl
URL: https://github.com/ingydotnet/vroom-pm

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/I/IN/INGY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Ever given a Slide Show and needed to switch over to Vim?

Now you don't ever have to switch again. You're already there.

Vroom lets you create your slides in a single file using a Wiki-like
style, much like Spork and Sporx do. The difference is that your slides
don't compile to HTML or JavaScript or XUL. They get turned into a set
of files that begin with '0', like '03' or '07c' or '05b.pl'.

The slides are named in alphabetic order. That means you can bring them
all into a Vim session with the command: `vim 0*'. `vroom vroom'
does exactly that.

You can do things like advance to the next slide with the spacebar.
Vroom creates a file called `./.vimrc' with helpful key mappings for
navigating a slideshow. See the KEY MAPPINGS entry elsewhere in this document below.

Vroom takes advantage of Vim's syntax highlighting. It also lets you run
slides that contain code.

Since Vim is an editor, you can change your slides during the show.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes CONTRIBUTING LICENSE README
%perl_vendor_privlib/V*

%files scripts
%_bindir/*

%changelog
