%define module_name WHO-GrowthReference-Table
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Section/Seekable/Reader.pm) perl(Data/TableData/Lookup.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Text/CSV.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.013
Release: alt1
Summary: Lookup height/weight in the WHO growth chart (a.k.a. growth reference, growth standards)
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/WHO-GrowthReference-Table

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use WHO::GrowthReference::Table qw(get_who_growth_reference);

 # get mean height & weight of a 3-year old girl

 my $res = get_who_growth_reference(gender => "F", dob => time() - 3*365.25*86400);
 # => [200, "OK", {
 #      age => "36.0 month(s)",
 #      mean_height => 95.034, # cm
 #      mean_weight => 13.9,   # kg
 #     }]

 # you have a 3.5-year old boy weighing at 14.8kg and with a height of 102cm,
 # calculate the percentiles

 my $res = get_who_growth_reference(gender => "M", dob => time() - 3.5*365.25*86400, weight=>14.8, height=>102);
 # => [200, "OK", {
 #      age => "42.0 month(s)",
 #      mean_height => 99.844, # cm
 #      height_percentile => 70.2, # your boy's height is above world average, about 70.2%% of boys of the same age are shorter than your boy
 #      mean_weight => 15.3,   # kg
 #      weight_percentile => 39.6, # your boy's weight is below world average, about 39.6%% of boys of the same age weigh less than your boy
 #     }]

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/W*

%changelog
