%define module_name WSRF-Lite
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Crypt/OpenSSL/RSA.pm) perl(Crypt/OpenSSL/X509.pm) perl(DateTime.pm) perl(DateTime/Format/Epoch.pm) perl(DateTime/Format/W3CDTF.pm) perl(DateTime/Locale.pm) perl(DateTime/TimeZone.pm) perl(Digest/SHA1.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Daemon.pm) perl(HTTP/Daemon/SSL.pm) perl(HTTP/Date.pm) perl(HTTP/Request.pm) perl(HTTP/Response.pm) perl(HTTP/Status.pm) perl(IO/Socket/SSL.pm) perl(JSON.pm) perl(LWP/MediaTypes.pm) perl(LWP/Simple.pm) perl(List/MoreUtils.pm) perl(MIME/Base64.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Params/Validate.pm) perl(Parse/CPAN/Meta.pm) perl(SOAP/Lite.pm) perl(Sys/Hostname/Long.pm) perl(Test/More.pm) perl(Test/Simple.pm) perl(URI.pm) perl(XML/DOM.pm) perl(XML/LibXML.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.8.3.4
Release: alt1
Summary: Implementation of WSRF
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/EK/EKAWAS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
WSRF::Lite consists of a number of classes for developing WS-Resources. 
A WS-Resource is an entity that has a Web service interface defined by
the WSRF family of specifications that maintains state between calls
to the service. 

WSRF::Lite provides a number of ways of implementing 
WS-Resources: one approach uses a process to store the state of the 
WS-Resource, another approach uses a process to store the state of many 
WS-Resources and the last approach uses files to store the state of the
WS-Resources between calls to the WS-Resource. The different approachs have
different benifits, using one process per WS-Resource does not scale very
well and isn't very fault tolerant (eg a machine reboot) but is quite
easy to develop. The approachs are just examples of how to implement a 
WS-Resource, it should be possible to use them as a basis to develop 
tailored solutions for particular applications. For example you could use a 
relational database to store the state of the WS-Resources.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README TODO
%perl_vendor_privlib/W*

%changelog
