# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config/General.pm) perl(Data/Dumper.pm) perl(DateTime.pm) perl(DateTime/Duration.pm) perl(Digest/MD5.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(FindBin.pm) perl(Getopt/Long.pm) perl(Hash/Merge.pm) perl(IO/File.pm) perl(LWP/UserAgent.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(Net/Google/Analytics.pm) perl(Net/Google/Analytics/OAuth2.pm) perl(POSIX.pm) perl(Params/Validate.pm) perl(Parse/RecDescent.pm) perl(Path/Class.pm) perl(Pod/Usage.pm) perl(Spreadsheet/ParseExcel.pm) perl(Spreadsheet/WriteExcel.pm) perl(Spreadsheet/WriteExcel/Utility.pm) perl(Storable.pm) perl(Test/Deep.pm) perl(Test/More.pm) perl(Text/CSV_XS.pm) perl(Text/Table.pm)
# END SourceDeps(oneline)
%define module_version 0.36
%define module_name WWW-Analytics-MultiTouch
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.36
Release: alt1
Summary: Multi-touch web analytics, using Google Analytics
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JJ/JJSCHUTZ/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module provides reporting for multi-touch web analytics, as described at
http://www.multitouchanalytics.com.  

Unlike typical last-session attribution web analytics, multi-touch gives insight
into all of the various marketing channels to which a visitor is exposed before
finally making the decision to buy.

Multi-touch analytics uses a javascript library to send information from a
web user's browser to Google Analytics for raw data collection; this module uses
the Google Analytics API to collate the data and then summarises it in a
spreadsheet, showing (for example):

=over 4

=item * Summary of marketing channels and number of transactions to which each channel
had some contribution (sum of transactions > total transactions)

=item * Summary of channels and fair attribution of transactions (sum of
transactions = total transactions)

=item * First touch, last touch, fifty-fifty first/last touch, and even attribution of transactions.

=item * Overlap analysis

=item * Transaction/touch distribution

=item * List of each transaction and the contributing channels

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/W*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
