%define module_name WWW-CSRF
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bytes/Random/Secure.pm) perl(Digest/HMAC_SHA1.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.00
Release: alt2
Summary: Generate and check tokens to protect against CSRF attacks
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SE/SESSE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module generates tokens to help protect against a website
attack known as Cross-Site Request Forgery (CSRF, also known
as XSRF).  CSRF is an attack where an attacker fools a browser into
make a request to a web server for which that browser will
automatically include some form of credentials (cookies, cached
HTTP Basic authentication, etc.), thus abusing the web server's
trust in the user for malicious use.

The most common CSRF mitigation is sending a special, hard-to-guess
token with every request, and then require that any request that
is not idempotent (i.e., has side effects) must be accompanied
with such a token.  This mitigation depends critically on the fact
that while an attacker can easily make the victim's browser
*make* a request, the browser security model (same-origin policy,
or SOP for short) prevents third-party sites from reading the
*results* of that request.

CSRF tokens should have at least the following properties:

=over

=item *
They should be hard-to-guess, so they should be signed
with some key known only to the server.

=item *
They should be dependent on the authenticated identity,
so that one user cannot use its own tokens to impersonate
another user.

=item *
They should not be the same for every request, or an
attack known as BREACH can use HTTP compression
to gradually deduce more and more of the token.

=item *
They should contain an (authenticated) timestamp, so
that if an attacker manages to learn one token, he or she
cannot impersonate a user indefinitely.

=back

WWW::CSRF simplifies the (simple, but tedious) work of creating and verifying
such tokens.

Note that resources that are protected against CSRF should also be protected
against a different attack known as clickjacking.  There are many defenses
against clickjacking (which ideally should be combined), but a good start is
sending a `X-Frame-Options' HTTP header set to `DENY' or `SAMEORIGIN'.
See the Wikipedia article on clickjacking
for more information.

This module provides the following functions:

=over 4

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/W*

%changelog
